<?php
include 'db.php';

$message_sent = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name    = $conn->real_escape_string($_POST['name']);
    $email   = $conn->real_escape_string($_POST['email']);
    $subject = $conn->real_escape_string($_POST['subject']);
    $message = $conn->real_escape_string($_POST['message']);

    $sql = "INSERT INTO contact_messages (name, email, subject, message) 
            VALUES ('$name', '$email', '$subject', '$message')";

    if ($conn->query($sql) === TRUE) {
        $message_sent = true;
    } else {
        echo "Error: " . $conn->error;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Contact – Wonder Lanka</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
<style>
  * { margin:0; padding:0; box-sizing:border-box; font-family:'Poppins', sans-serif; }
  body { background:#f0f4f5; color:#222; line-height:1.6; }

  /* Header */
  header { background:#004d40; color:#e0f2f1; padding:20px 8%; display:flex; justify-content:space-between; align-items:center; }
  header h1 { color:#80cbc4; font-size:1.8em; }
  nav a { color:#e0f2f1; text-decoration:none; margin:0 15px; font-weight:500; transition:0.3s; }
  nav a:hover { color:#fff; }

  /* Hero */
  .hero { height:35vh; background:url('images/WhatsApp Image 2025-10-13 at 09.07.40.jpeg') center/cover no-repeat; display:flex; align-items:center; justify-content:center; position:relative; }
  .hero::after { content:""; position:absolute; inset:0; background:rgba(0,0,0,0.6); }
  .hero-content { position:relative; text-align:center; color:#fff; animation:fadeIn 1.5s ease forwards; }
  .hero-content h1 { font-size:2.8em; margin-bottom:10px; letter-spacing:2px; }
  .hero-content h2 { font-size:1.5em; color:#b2dfdb; margin-bottom:10px; }
  .hero-content p { font-size:1.1em; }

  /* Contact Section */
  section { padding:80px 8%; display:flex; flex-wrap:wrap; justify-content:center; gap:40px; }
  .contact-container { display:flex; flex-wrap:wrap; max-width:1200px; width:100%; border-radius:20px; overflow:hidden; box-shadow:0 15px 40px rgba(0,0,0,0.1); }

  /* Left Side: Map & Info */
  .contact-left { flex:1 1 500px; background:linear-gradient(135deg,#004d40,#00897b); color:#fff; padding:40px; display:flex; flex-direction:column; justify-content:space-between; }
  .contact-left h2 { margin-bottom:25px; color:#e0f2f1; }
  .contact-left p, .contact-left a { margin:10px 0; color:#fff; font-weight:500; text-decoration:none; display:flex; align-items:center; gap:10px; }
  .contact-left p i { color:#80cbc4; }
  iframe { border-radius:15px; margin-top:20px; width:100%; height:250px; border:none; }

  /* Right Side: Form */
  .contact-form { flex:1 1 500px; background:#fff; padding:50px; display:flex; flex-direction:column; justify-content:center; animation:slideIn 1s ease; }
  .contact-form h2 { color:#00796b; margin-bottom:25px; }
  .contact-form input, .contact-form textarea { width:100%; padding:15px; margin:10px 0; border-radius:10px; border:1px solid #ccc; font-size:1em; transition:0.3s; }
  .contact-form input:focus, .contact-form textarea:focus { border-color:#00897b; outline:none; box-shadow:0 0 10px rgba(0,137,123,0.2); }
  .contact-form button { background:#00897b; color:#fff; border:none; padding:15px; font-size:1em; border-radius:30px; cursor:pointer; margin-top:10px; transition:0.3s; }
  .contact-form button:hover { background:#004d40; transform:translateY(-3px); }
  .success-msg { text-align:center; color:green; font-weight:600; margin-bottom:20px; }

  /* Footer */
  footer { background:#004d40; color:#e0f2f1; text-align:center; padding:50px 8%; font-size:0.95em; }
  footer a { color:#80cbc4; text-decoration:none; margin:0 10px; }
  footer a:hover { color:#fff; }

  /* Animations */
  @keyframes fadeIn { from{opacity:0; transform:translateY(20px);} to{opacity:1; transform:translateY(0);} }
  @keyframes slideIn { from{opacity:0; transform:translateX(40px);} to{opacity:1; transform:translateX(0);} }

  /* Responsive */
  @media(max-width:900px){ .contact-container{ flex-direction:column; } iframe{ height:200px; } }
</style>
</head>
<body>

<header>
  <h1>Wonder Lanka</h1>
  <nav>
    <a href="index.html">Home</a>
    <a href="discover.php">Discover</a>
    <a href="blog.php">Blog</a>
    <a href="about.php">About</a>
    <a href="contact.php">Contact</a>
  </nav>
</header>

<div class="hero">
  <div class="hero-content">
    <h1>Contact Us</h1>
    <h2>We’d Love to Hear From You</h2>
    <p>Questions, suggestions, or feedback? Reach out and let us know!</p>
  </div>
</div>

<section>
  <div class="contact-container">

    <!-- Left Side -->
    <div class="contact-left">
      <h2>Our Office</h2>
      <p><i class="fas fa-map-marker-alt"></i> Colombo, Sri Lanka</p>
      <p><i class="fas fa-phone"></i> +94 71 123 4567</p>
      <p><i class="fas fa-envelope"></i> info@wonderlanka.com</p>
      <p>
        <a href="#"><i class="fab fa-facebook-f"></i> Facebook</a>
        <a href="#"><i class="fab fa-instagram"></i> Instagram</a>
      </p>
      <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3153.123456!2d79.8612!3d6.9271!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ae2570c7c1c7f33%3A0x1234567890abcdef!2sColombo%2C%20Sri%20Lanka!5e0!3m2!1sen!2sus!4v1696900000000!5m2!1sen!2sus" allowfullscreen="" loading="lazy"></iframe>
    </div>

    <!-- Right Side: Form -->
    <div class="contact-form">
      <?php if ($message_sent): ?>
        <p class="success-msg">Thank you! Your message has been sent.</p>
      <?php endif; ?>
      <h2>Send a Message</h2>
      <form action="" method="POST">
        <input type="text" name="name" placeholder="Your Name" required>
        <input type="email" name="email" placeholder="Your Email" required>
        <input type="text" name="subject" placeholder="Subject" required>
        <textarea name="message" rows="6" placeholder="Your Message" required></textarea>
        <button type="submit">Send Message</button>
      </form>
    </div>

  </div>
</section>

<footer>
  <p>
    <a href="index.html">Home</a> | 
    <a href="discover.php">Discover</a> | 
    <a href="blog.php">Blog</a> | 
    <a href="about.php">About</a> | 
    <a href="contact.php">Contact</a>
  </p>
  <p>© 2025 Wonder Lanka. All Rights Reserved.</p>
</footer>

</body>
</html>
