<?php
include 'db.php'; // Database connection

// Get search query
$search_query = isset($_GET['q']) ? $conn->real_escape_string($_GET['q']) : '';

// Fetch posts matching search
$sql = "SELECT p.*, c.name AS category_name 
        FROM posts p
        JOIN categories c ON p.category_id = c.id
        WHERE p.title LIKE '%$search_query%' OR p.content LIKE '%$search_query%'
        ORDER BY p.created_at DESC";
$result = $conn->query($sql);

// Fetch categories with post counts
$cat_sql = "SELECT c.id, c.name, COUNT(p.id) AS post_count 
            FROM categories c 
            LEFT JOIN posts p ON p.category_id = c.id 
            GROUP BY c.id";
$categories = $conn->query($cat_sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Search Results – Wonder Lanka</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
/* Use same CSS as blog/category pages */
* { margin:0; padding:0; box-sizing:border-box; }
body { font-family: 'Poppins', sans-serif; background:#fafafa; color:#222; line-height:1.7; }
a { text-decoration:none; color:inherit; }

header { position:sticky; top:0; z-index:1000; background:#fff; display:flex; justify-content:space-between; align-items:center; padding:15px 8%; box-shadow:0 2px 8px rgba(0,0,0,0.05);}
header h1 { color:#00897b; font-size:1.8em; font-weight:700; }
nav a { margin:0 14px; font-weight:500; color:#333; position:relative; }
nav a:hover { color:#00897b; }
.menu-toggle { display:none; flex-direction:column; cursor:pointer; }
.menu-toggle span { background:#333; height:3px; width:25px; margin:4px 0; transition:0.3s; }

.hero { height:40vh; display:flex; align-items:center; justify-content:center; color:#fff; position:relative; background: url('images/WhatsApp Image 2025-10-13 at 16.25.16.jpeg') center/cover no-repeat; }
.hero::after { content:''; position:absolute; inset:0; background:rgba(0,0,0,0.5); }
.hero h1 { position:relative; font-size:2.8em; text-align:center; }

section { padding:80px 8%; }
h2 { text-align:center; color:#00796b; font-size:2.2em; margin-bottom:40px; position:relative; }
h2::after { content:""; width:60px; height:3px; background:#00897b; display:block; margin:10px auto; border-radius:2px; }

.blog-container { display:flex; gap:30px; flex-wrap:wrap; }
.left-column { flex:2; display:grid; grid-template-columns:1fr 1fr; gap:25px; }
.blog-card { background:#fff; border-radius:15px; overflow:hidden; box-shadow:0 5px 15px rgba(0,0,0,0.1); display:flex; flex-direction:column; transition: transform 0.3s, box-shadow 0.3s; }
.blog-card:hover { transform:translateY(-8px); box-shadow:0 10px 20px rgba(0,0,0,0.15); }
.blog-card img { width:100%; height:180px; object-fit:cover; }
.card-content { padding:15px; flex:1; display:flex; flex-direction:column; justify-content:space-between; }
.card-content h4 { font-size:1em; color:#00897b; margin-bottom:5px; }
.card-content h3 { font-size:1.2em; color:#004d40; margin-bottom:8px; }
.card-content p { font-size:0.9em; color:#555; margin-bottom:12px; }
.card-content a { font-weight:600; color:#00897b; transition:color 0.3s; }
.card-content a:hover { color:#004d40; text-decoration:underline; }

.right-column { flex:1; display:flex; flex-direction:column; gap:30px; }
.search-box, .category-box { background:#fff; padding:20px; border-radius:15px; box-shadow:0 5px 15px rgba(0,0,0,0.1); }
.category-box h3, .search-box h3 { font-size:1.2em; color:#004d40; margin-bottom:15px; }
.category-box ul { list-style:none; display:flex; flex-direction:column; gap:10px; }
.category-box ul li a { color:#00897b; font-weight:500; transition:0.3s; }
.category-box ul li a:hover { color:#004d40; text-decoration:underline; }

footer { background:#004d40; color:#e0f2f1; text-align:center; padding:50px 8%; font-size:0.95em; }
footer a { color:#80cbc4; text-decoration:none; margin:0 10px; transition:color 0.3s; }
footer a:hover { color:#fff; }

@media(max-width:1024px) { .left-column { grid-template-columns:1fr; } }
@media(max-width:768px) { 
  .blog-container { flex-direction:column; }
  nav { display:none; flex-direction:column; background:#fff; position:absolute; top:65px; right:8%; width:200px; box-shadow:0 5px 15px rgba(0,0,0,0.1); border-radius:10px; }
  nav.active { display:flex; }
  .menu-toggle { display:flex; }
}
</style>
</head>
<body>

<header>
  <h1>Wonder Lanka</h1>
  <nav id="navMenu">
  
    <a href="index.html">Home</a> | 
    <a href="discover.php">Discover</a> | 
    <a href="blog.php">Blog</a> | 
    <a href="about.php">About</a> | 
    <a href="contact.php">Contact</a>
  </nav>
  <div class="menu-toggle" id="menuToggle"><span></span><span></span><span></span></div>
</header>

<section class="hero">
  <h1>Search Results for "<?php echo htmlspecialchars($search_query); ?>"</h1>
</section>

<section>
  <div class="blog-container">
    <div class="left-column">
      <?php if($result->num_rows > 0): ?>
        <?php while($post = $result->fetch_assoc()): ?>
          <div class="blog-card">
            <img src="<?php echo htmlspecialchars($post['image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>">
            <div class="card-content">
              <h4><?php echo htmlspecialchars($post['category_name']); ?></h4>
              <h3><?php echo htmlspecialchars($post['title']); ?></h3>
              <p>By <?php echo htmlspecialchars($post['author']); ?> | <?php echo date('d M Y', strtotime($post['created_at'])); ?></p>
              <p><?php echo substr(strip_tags($post['content']),0,150); ?>...</p>
              <a href="single_post.php?id=<?php echo $post['id']; ?>">Read More →</a>
            </div>
          </div>
        <?php endwhile; ?>
      <?php else: ?>
        <p>No posts found for "<?php echo htmlspecialchars($search_query); ?>"</p>
      <?php endif; ?>
    </div>

    <div class="right-column">
      <div class="search-box">
        <h3>Search Posts</h3>
        <form action="search_results.php" method="get">
          <input type="text" name="q" placeholder="Search for stories..." value="<?php echo htmlspecialchars($search_query); ?>">
        </form>
      </div>
      <div class="category-box">
        <h3>Categories</h3>
        <ul>
          <?php if($categories->num_rows > 0): ?>
            <?php while($cat = $categories->fetch_assoc()): ?>
              <li>
                <a href="category.php?id=<?php echo $cat['id']; ?>">
                  <?php echo htmlspecialchars($cat['name']); ?> (<?php echo $cat['post_count']; ?>)
                </a>
              </li>
            <?php endwhile; ?>
          <?php else: ?>
            <li>No categories found.</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>
</section>

<footer>
  <p>
    <a href="index.html">Home</a> | 
    <a href="discover.php">Discover</a> | 
    <a href="blog.php">Blog</a> | 
    <a href="about.php">About</a> | 
    <a href="contact.php">Contact</a>
  </p>
  <p>© 2025 Wonder Lanka. All Rights Reserved.</p>
</footer>

<script>
const menuToggle = document.getElementById('menuToggle');
const navMenu = document.getElementById('navMenu');
menuToggle.addEventListener('click', () => {
  navMenu.classList.toggle('active');
});
</script>
</body>
</html>
