<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>About Us – Wonder Lanka</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
/* Base */
*{margin:0;padding:0;box-sizing:border-box;}
body{font-family:"Poppins",sans-serif;background:#f8fafc;color:#333;line-height:1.6;}
header{background:#fff;display:flex;justify-content:space-between;align-items:center;padding:20px 8%;box-shadow:0 2px 8px rgba(0,0,0,0.05);position:sticky;top:0;z-index:10;}
header h1{color:#00897b;font-weight:700;}
nav a{text-decoration:none;color:#333;margin:0 15px;font-weight:500;position:relative;}
nav a:hover{color:#00897b;}
nav a::after{content:"";position:absolute;left:0;bottom:-5px;width:0;height:2px;background:#00897b;transition:width 0.3s;}
nav a:hover::after{width:100%;}

/* Hero */
.hero{
    background:url('images/WhatsApp Image 2025-10-13 at 09.07.40.jpeg') center/cover;
    color:#fff;text-align:center;padding:150px 8%;position:relative;
}
.hero::after{content:"";position:absolute;inset:0;background:rgba(0,0,0,0.55);}
.hero-content{position:relative;z-index:2;}
.hero-content h1{font-size:3em;letter-spacing:2px;margin-bottom:10px;}
.hero-content p{font-size:1.2em;color:#e0f2f1;}

/* Section Titles */
.section-title{text-align:center;font-size:2em;color:#00796b;margin-bottom:40px;}

/* About Text */
.about-text{max-width:900px;margin:0 auto;text-align:center;}
.about-text h2{color:#004d40;margin-bottom:20px;font-size:2em;}
.about-text p{font-size:1.1em;margin-bottom:15px;color:#555;}

/* Mission & Vision */
.mission-vision{display:flex;flex-wrap:wrap;gap:40px;justify-content:center;margin-top:60px;}
.card{background:#fff;padding:30px;border-radius:15px;box-shadow:0 5px 15px rgba(0,0,0,0.1);flex:1 1 300px;transition:transform .3s;}
.card:hover{transform:translateY(-8px);}
.card h3{color:#00796b;margin-bottom:15px;}
.card p{color:#555;font-size:1em;}

/* Team */
.team{margin-top:60px;}
.team-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:30px;}
.team-member{background:#fff;padding:20px;border-radius:15px;text-align:center;box-shadow:0 5px 15px rgba(0,0,0,0.1);transition:transform .3s;}
.team-member:hover{transform:translateY(-6px);}
.team-member img{width:120px;height:120px;border-radius:50%;object-fit:cover;margin-bottom:15px;}
.team-member h4{color:#004d40;margin-bottom:5px;}
.team-member span{color:#777;font-size:0.9em;}

/* History Timeline */
.timeline{margin-top:60px;position:relative;padding-left:20px;}
.timeline::before{content:"";position:absolute;top:0;left:30px;width:4px;height:100%;background:#00897b;}
.timeline-item{position:relative;margin-bottom:50px;padding-left:60px;}
.timeline-item h4{color:#00796b;margin-bottom:5px;}
.timeline-item p{color:#555;}
.timeline-item::before{content:"";position:absolute;left:22px;top:5px;width:16px;height:16px;background:#00897b;border-radius:50%;}

/* Footer */
footer{text-align:center;padding:40px 8%;background:#004d40;color:#e0f2f1;margin-top:80px;}
footer a{color:#80cbc4;text-decoration:none;margin:0 10px;}
footer a:hover{color:#fff;}

/* Responsive */
@media(max-width:768px){.mission-vision{flex-direction:column;}}
</style>
</head>
<body>

<header>
  <h1>Wonder Lanka</h1>
  <nav>
    <a href="index.php">Home</a>
    <a href="discover.php">Discover</a>
    <a href="blog.php">Blog</a>
    <a href="about.php">About</a>
    <a href="contact.php">Contact</a>
  </nav>
</header>

<section class="hero">
  <div class="hero-content">
    <h1>About Us</h1>
    <p>Celebrating the heart of Sri Lanka — its culture, people, and stories.</p>
  </div>
</section>

<section class="about-text container">
  <h2>Who We Are</h2>
  <p><strong>Wonder Lanka</strong> is a mixed-media platform dedicated to exploring the beauty, culture, and heritage of Sri Lanka. We provide a window into the island’s breathtaking landscapes, vibrant festivals, historic landmarks, and everyday life.</p>
  <p>Our goal is to inspire, educate, and connect people to the essence of Sri Lanka through stories, galleries, and experiences shared by locals and travelers alike.</p>
</section>

<section class="mission-vision container">
  <div class="card">
    <h3>Our Mission</h3>
    <p>To showcase Sri Lanka’s unique culture, natural beauty, and traditions, promoting sustainable tourism and cultural understanding globally.</p>
  </div>
  <div class="card">
    <h3>Our Vision</h3>
    <p>To become the go-to platform for discovering Sri Lanka’s heart — from hidden gems to iconic landmarks, connecting people with authentic experiences.</p>
  </div>
</section>

<section class="team container">
  <h2 class="section-title">Meet Our Team</h2>
  <div class="team-grid">
    <div class="team-member">
      <img src="images/WhatsApp Image 2025-10-15 at 22.15.05.jpeg" alt="Himasha Mohomed Lafeer">
      <h4>Ms.M.L.Himasha</h4>
      <span>Founder & Content Creator</span>
    </div>
   
     <div class="team-member">
      <img src="images/team2.jpg" alt="Nimal Perera">
      <h4>Mr.Niwantha Dilshan</h4>
      <span>Mentor</span>
    </div>
     <div class="team-member">
      <img src="images/WhatsApp Image 2025-10-15 at 22.04.51.jpeg" alt="Nimal Perera">
      <h4>Ms.Dilrukshi</h4>
      <span>Team Member</span>
    </div>
    <div class="team-member">
      <img src="images/WhatsApp Image 2025-10-15 at 22.10.12.jpeg" alt="Samantha Fernando">
      <h4>Ms.Priya</h4>
      <span>Team Member</span>
    </div>
     <div class="team-member">
      <img src="images/WhatsApp Image 2025-10-15 at 22.04.51(1).jpeg" alt="Nimal Perera">
      <h4>Ms.Niluksika</h4>
      <span>Team Member</span>
    </div>
     <div class="team-member">
      <img src="images/WhatsApp Image 2025-10-15 at 22.04.52.jpeg" alt="Nimal Perera">
      <h4>Ms.Krishanthi</h4>
      <span>Team Member</span>
    </div>
  </div>
</section>

<section class="timeline container">
  <h2 class="section-title">Our Journey</h2>
  <div class="timeline-item">
    <h4>2024</h4>
    <p>Wonder Lanka was founded to celebrate the island’s culture and natural beauty.</p>
  </div>
  <div class="timeline-item">
    <h4>2025</h4>
    <p>Expanded coverage to include festivals, cuisine, hidden gems, and community stories.</p>
  </div>
  <div class="timeline-item">
    <h4>2025 Onwards</h4>
    <p>Ongoing mission to promote Sri Lanka globally through blogs, photography, and storytelling.</p>
  </div>
</section>

<footer>
  <p>
    <a href="index.php">Home</a> | 
    <a href="discover.php">Discover</a> | 
    <a href="blog.php">Blog</a> | 
    <a href="about.php">About</a> | 
    <a href="contact.php">Contact</a>
  </p>
  <p>© 2025 Wonder Lanka. All Rights Reserved.</p>
</footer>

</body>
</html>
